<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\Traits\LanguageFallbackForWidgetBuilder;
use Plugins\WidgetBuilder\WidgetBase;


class TenantHotelBookingContactWidget extends WidgetBase
{
    use LanguageFallbackForWidgetBuilder;
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();
        $widget_saved_values = $this->get_settings();
        $output .= $this->admin_language_tab_start();


        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'multi_lang' => true,
            'id' => 'tenant_hotel_booking_contact_widget_one',
            'fields' => [
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_title',
                    'label' => __('Title'),
                ],
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_contact',
                    'label' => __('Contact'),
                ],
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_icon',
                    'label' => __('Icon Class')
                ],
            ]
        ]);

        $output .= $this->admin_language_tab_end();
        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return true; // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $user_selected_language = get_user_lang();
        $repeader_data = $this->setting_item('tenant_hotel_booking_contact_widget_one') ?? [];

        $contact_markup = '';
        foreach ($repeader_data['repeater_icon_'.$user_selected_language] ?? [] as $key =>  $item)
        {
            $repeater_title = $repeader_data['repeater_title_'.$user_selected_language][$key] ?? '';
            $repeater_icon = $repeader_data['repeater_icon_'.$user_selected_language][$key] ?? '';
            $repeater_contact = $repeader_data['repeater_contact_'.$user_selected_language][$key] ?? '';

            $contact_markup.= <<<MARKUP

            <div class="copyright-contents-single">
                 <div class="copyright-contents-single-flex">
                     <div class="copyright-contents-single-icon">
                        <i class="{$repeater_icon}"></i>
                    </div>
                    <div class="copyright-contents-single-details">
                        <span class="copyright-contents-single-details-title"> {$repeater_title} </span>
                        <a href="mailto:unreal@example.com" class="copyright-contents-single-details-link"> {$repeater_contact} </a>
                    </div>
                </div>
            </div>

            MARKUP;
        }

        return <<<HTML
        {$contact_markup}
        HTML;

    }

    public function widget_title(){
        return __('Hotel Booking Contact Widget');
    }

    public function columnClass(){
        return 'col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-8';
    }

}
